import java.util.*;
import java.util.concurrent.*;

class CyclicBarrierDemo {
	static final int SAMPLE_SIZE = 10_000;
	static final int N_SAMPLES = 10;
	static int ex = 0;
	static final int N_EXPERIMENTS = 5;
	static double[] data = new double[N_SAMPLES];

	static final Runnable barrierAction = new Runnable() {
		@Override
		public void run() {
			double sum = 0.0;
			double qs = 0.0;
			for(int i = 0; i < N_SAMPLES; i++) {
				sum += data[i];
				qs += data[i] * data[i];
			}
			double mean = sum / N_SAMPLES;
			double variance = (qs - N_SAMPLES *mean*mean) / (N_SAMPLES - 1); // Verschiebungsformel
			double se = Math.sqrt(variance);
			System.out.println("SE(" + ex++ + ") = " + se);
		}
	};

	static final CyclicBarrier barrier = new CyclicBarrier(N_SAMPLES, barrierAction);

	static class Meaner implements Runnable {
		private int sample;
		private Random zzg = new Random();
		Meaner(int i) {
			sample = i;
		}
		public void run() {
			while (ex < N_EXPERIMENTS) {
				double mean = 0.0;
				for (int i = 0; i < SAMPLE_SIZE; i++)
					mean = mean + zzg.nextDouble();
				data[sample] = mean / SAMPLE_SIZE;
		//				System.out.println(data[col]);
				try {
					barrier.await();
				} catch (InterruptedException | BrokenBarrierException ex) {
					System.out.println("Meaner " + sample + " havariert.");
					System.exit(1);
				}
			}
		//			System.out.println("Thread " + col + " is ready");
		}
	}

	public static void main(String[] args) {
		for (int i = 0; i < N_SAMPLES; i++)
			new Thread(new Meaner(i)).start();
	}
}
